<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('Languages', function (Blueprint $table) {
            $table->bigIncrements('Language_id');
            $table->string('Code', 10)->unique();
            $table->string('Name', 100);
            $table->timestamp('Created_at')->useCurrent();
        });

        
    }

    public function down(): void
    {
        Schema::dropIfExists('Languages');
    }
};
